/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.step.core.attachments;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWParameter;
import filenet.vw.api.VWStepElement;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.step.core.attachments.VWAttachmentHelper;
import filenet.vw.toolkit.runtime.step.core.attachments.VWAttachmentTableRowItem;
import filenet.vw.toolkit.runtime.step.core.attachments.VWIDMItem;
import filenet.vw.toolkit.runtime.step.resources.VWResource;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.IVWTableOperation;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

class VWAttachmentTableModel
extends AbstractTableModel
implements IVWTableOperation {
    public static final int COL_EXPAND = 0;
    public static final int COL_PARAM = 1;
    public static final int COL_ATTACH_ITEM = 2;
    public static final int COL_ATTACH_LIBRARY = 3;
    public static final int COL_ATTACH_ID = 4;
    private String[] m_headers = null;
    private Class[] m_columnClasses = null;
    private Vector m_rowData;
    private VWStepElement m_vwStepElement = null;

    public VWAttachmentTableModel(VWStepElement stepElement, VWSessionInfo sessionInfo) {
        try {
            this.m_vwStepElement = stepElement;
            if (sessionInfo.isWorkPlaceWebApp()) {
                this.m_headers = new String[]{"", VWResource.s_name, VWResource.s_item, VWResource.s_objectStore};
                this.m_columnClasses = new Class[]{Boolean.class, VWParameter.class, VWIDMItem.class, String.class};
            } else {
                this.m_headers = new String[]{"", VWResource.s_name, VWResource.s_item, VWResource.s_library, VWResource.s_id};
                this.m_columnClasses = new Class[]{Boolean.class, VWParameter.class, VWIDMItem.class, String.class, String.class};
            }
            this.retrieveRowData();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Class getColumnClass(int index) {
        return this.m_columnClasses[index];
    }

    public int getColumnCount() {
        return this.m_headers.length;
    }

    public String getColumnName(int index) {
        return this.m_headers[index];
    }

    public int getRowCount() {
        int nCount = 0;
        if (this.m_rowData != null) {
            for (int nIndex = 0; nIndex < this.m_rowData.size(); ++nIndex) {
                VWAttachmentTableRowItem rowItem = this.getRowItemAt(nIndex);
                if (rowItem == null) continue;
                if (rowItem.isExpanded()) {
                    nCount += rowItem.getRowCount();
                    continue;
                }
                ++nCount;
            }
        }
        return nCount;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        int[] nIndexes = new int[2];
        boolean bFound = this.tableToDataRow(nRowIndex, nIndexes);
        if (bFound) {
            int nParameterIndex = nIndexes[0];
            int nArrayIndex = nIndexes[1];
            VWAttachmentTableRowItem rowItem = this.getRowItemAt(nParameterIndex);
            if (rowItem != null) {
                VWIDMItem idmItem = rowItem.getItemAt(nArrayIndex);
                switch (nColumnIndex) {
                    case 0: {
                        if (nArrayIndex != 0 || !rowItem.isExpandable()) break;
                        if (rowItem.isExpanded()) {
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }
                    case 1: {
                        if (idmItem == null) break;
                        if (idmItem.getArrayIndex() > 0) {
                            return null;
                        }
                        return rowItem.getParameter();
                    }
                    case 2: {
                        if (idmItem == null) break;
                        return idmItem;
                    }
                    case 3: {
                        if (idmItem == null) break;
                        return idmItem.getLibraryName();
                    }
                    case 4: {
                        if (idmItem == null) break;
                        return idmItem.getAttachmentId();
                    }
                }
            }
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                int[] nIndexes = new int[2];
                boolean bFound = this.tableToDataRow(nRowIndex, nIndexes);
                if (bFound) {
                    int nStepIndex = nIndexes[0];
                    int nArrayIndex = nIndexes[1];
                    VWAttachmentTableRowItem rowItem = this.getRowItemAt(nStepIndex);
                    if (rowItem != null && nArrayIndex == 0 && rowItem.isExpandable()) {
                        return true;
                    }
                }
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return false;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                int[] nIndexes = new int[2];
                boolean bFound = this.tableToDataRow(nRowIndex, nIndexes);
                if (!bFound) break;
                int nStepIndex = nIndexes[0];
                int nArrayIndex = nIndexes[1];
                VWAttachmentTableRowItem rowItem = this.getRowItemAt(nStepIndex);
                if (rowItem == null || nArrayIndex != 0 || !rowItem.isExpandable() || aValue == null || !(aValue instanceof Boolean) || rowItem.isExpanded() == ((Boolean)aValue).booleanValue()) break;
                rowItem.setExpanded((Boolean)aValue);
                this.fireTableDataChanged();
                break;
            }
        }
    }

    public void openItem(int rowIndex) {
        block6: {
            try {
                Object value = this.getValueAt(rowIndex, 2);
                if (!(value instanceof VWIDMItem)) break block6;
                VWIDMItem vwItem = (VWIDMItem)value;
                if (vwItem.getDisplayName() == null) {
                    return;
                }
                try {
                    VWAttachmentHelper vwAttachmentHelper = vwItem.getAttachmentHelper();
                    if (vwAttachmentHelper != null) {
                        vwAttachmentHelper.open();
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    JOptionPane.showMessageDialog(null, ex.getMessage(), VWResource.s_unableToOpenAttachment, 0);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    public void refresh() {
    }

    protected boolean isRowEditable(int nRowIndex) {
        int[] nIndexes = new int[2];
        boolean bFound = this.tableToDataRow(nRowIndex, nIndexes);
        if (bFound) {
            int nParameterIndex = nIndexes[0];
            int nArrayIndex = nIndexes[1];
            VWAttachmentTableRowItem rowItem = this.getRowItemAt(nParameterIndex);
            if (rowItem != null) {
                if (rowItem.isExpandable()) {
                    return rowItem.isExpanded();
                }
                return true;
            }
        }
        return false;
    }

    protected void addAttachment(int nRowIndex, VWAttachment newAttachment) {
        int[] nIndexes = new int[2];
        boolean bFound = this.tableToDataRow(nRowIndex, nIndexes);
        if (bFound) {
            int nParameterIndex = nIndexes[0];
            int nArrayIndex = nIndexes[1];
            VWAttachmentTableRowItem rowItem = this.getRowItemAt(nParameterIndex);
            if (rowItem != null) {
                rowItem.addAttachment(newAttachment, this.m_vwStepElement);
                this.fireTableDataChanged();
            }
        }
    }

    protected boolean deleteAttachment(int nRowIndex, VWAttachment vwAttachment) {
        int[] nIndexes = new int[2];
        boolean bFound = this.tableToDataRow(nRowIndex, nIndexes);
        if (bFound) {
            int nParameterIndex = nIndexes[0];
            int nArrayIndex = nIndexes[1];
            VWAttachmentTableRowItem rowItem = this.getRowItemAt(nParameterIndex);
            if (rowItem != null && rowItem.deleteAttachment(nArrayIndex, this.m_vwStepElement)) {
                this.fireTableDataChanged();
                return true;
            }
        }
        return false;
    }

    protected void updateAttachment(int nRowIndex, VWAttachment vwAttachment) {
        int[] nIndexes = new int[2];
        boolean bFound = this.tableToDataRow(nRowIndex, nIndexes);
        if (bFound) {
            int nParameterIndex = nIndexes[0];
            int nArrayIndex = nIndexes[1];
            VWAttachmentTableRowItem rowItem = this.getRowItemAt(nParameterIndex);
            if (rowItem != null) {
                rowItem.updateAttachment(nArrayIndex, vwAttachment, this.m_vwStepElement);
                this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            }
        }
    }

    private void retrieveRowData() {
        try {
            this.m_rowData = new Vector();
            if (this.m_vwStepElement == null) {
                return;
            }
            VWParameter[] parameters = this.m_vwStepElement.getParameters(32, 1);
            if (parameters.length > 0) {
                for (int j = 0; j < parameters.length; ++j) {
                    String parameterName = parameters[j].getName();
                    boolean bInserted = false;
                    for (int i = 0; i < this.m_rowData.size(); ++i) {
                        VWAttachmentTableRowItem rowItem = (VWAttachmentTableRowItem)this.m_rowData.elementAt(i);
                        if (VWStringUtils.compare(parameterName, rowItem.getParameter().getName()) >= 0) continue;
                        this.m_rowData.insertElementAt(new VWAttachmentTableRowItem(parameters[j]), i);
                        bInserted = true;
                        break;
                    }
                    if (bInserted) continue;
                    this.m_rowData.addElement(new VWAttachmentTableRowItem(parameters[j]));
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWAttachmentTableRowItem getRowItemAt(int nRowIndex) {
        VWAttachmentTableRowItem rowItem = null;
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            rowItem = (VWAttachmentTableRowItem)this.m_rowData.elementAt(nRowIndex);
        }
        return rowItem;
    }

    private boolean tableToDataRow(int nRow, int[] nIndexes) {
        boolean bFound = false;
        int nCount = 0;
        if (this.m_rowData == null) {
            return false;
        }
        for (int i = 0; i < this.m_rowData.size(); ++i) {
            VWAttachmentTableRowItem rowItem = this.getRowItemAt(i);
            int nRowCount = 0;
            if (rowItem != null) {
                nRowCount = rowItem.isExpanded() ? (nRowCount += rowItem.getRowCount()) : ++nRowCount;
            }
            if (nRow >= (nCount += nRowCount)) continue;
            bFound = true;
            nIndexes[0] = i;
            nIndexes[1] = nRow - nCount + nRowCount;
            break;
        }
        return bFound;
    }
}

